
@include('layout-parts.header')

@php
    $pagetitle = "Contact Us";
@endphp

@include('layout-parts.page-banner')

<section class="contact-page-section" style="background-image: url(assets/images/background/pattern-27.png)">
    <div class="auto-container">
        <div class="upper-box">
            <div class="row clearfix">
                <div class="info-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <span class="icon flaticon-location"></span>
                        <h4>Address</h4>
                        <div class="text">Dorado Advertising,
                            Industrial Area, Street 08, Doha, Qatar</div>
                    </div>
                </div>
                
                <div class="info-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <span class="icon flaticon-call"></span>
                        <h4>Our Phone</h4>
                        <a class="phone" href="tel:4142 2481">4142 2481</a><br>
                        <a class="phone" href="tel:3399 5586">3399 5586</a><br>
                        <a class="phone" href="tel:5585 4132">5585 4132</a>
                    </div>
                </div>
                <div class="info-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <span class="icon flaticon-send"></span>
                        <h4>Email address</h4>
                        <a class="email" href="mailto:info@dorado.qa">info@dorado.qa</a><br>
                        <a class="email" href="mailto:dorado2013@yahoo.com">dorado2013@yahoo.com</a>
                    </div>
                </div>
                
            </div>
        </div>
  
        <div class="form-container">
            <h3>Send us message</h3>
            <div class="contact-form">
                <form method="post" action="/contact-us">
                    <input type="hidden" name="_token" value="<?php echo csrf_token(); ?>">
                    <div class="form-group">
                        <input type="text" name="name" placeholder="Full Name" required>
                    </div>
                    
                    <div class="form-group">
                        <input type="email" name="email" placeholder="Email address" required>
                    </div>

                    <div class="form-group">
                        <input type="text" name="phone" placeholder="Phone" required>
                    </div>
                    
                    <div class="form-group">
                        <textarea class="" name="content" placeholder="Type your message"></textarea>
                    </div>
                    
                    <div class="form-group">
                        @error('content')
								<div class="alert alert-danger">
                        			<span class="text-danger text-white"> {{ $message }} </span>
								</div>	
                        		@enderror
								@if (\Session::has('email_status'))
									<div class="alert {!! \Session::get('message_type') !!}">		
										<ul>
											<li>{!! \Session::get('email_status') !!}</li>
										</ul>
									</div>
								@endif
                    </div>

                    <div class="form-group">
                        <div class="button-box">
                            <button class="theme-btn btn-style-four">
                                <span class="txt">Submit</span>
                            </button>
                        </div>
                    </div>
                    
                </form>
            </div>
        
    </div>
</section>

@include('layout-parts.footer')