<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function contactus(Request $request){
        $request->validate([
            'email' => 'required|email',
            'name' => 'required',
            'phone' => 'required',
            'content' => 'required',
          ]);
          $data = [
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'content' => $request->content
          ];

          $EmailSent = Mail::send('email/contact-us', $data, function($message) use ($data) {
            $message->to("info@dorado.qa")
            ->subject("Dorado - Website Message");
          });
          
          if ($EmailSent) {
            return back()->with(['email_status' => 'Your message was successfully sent. Our support team will get back you soon.', 'message_type' => 'alert-success']);
          }else{
            return back()->with(['email_status' => 'Error! please try again', 'message_type' => 'alert-danger']);
          }
    }
}
